function Status = zz_report_txt(Reportstruct,openfile)
% function zz_report_txt(Reportstruct,openfile)
% ver 220420 SAM
% global Zset

if ~isfield(Reportstruct,'newbe')
    Reportstruct(1).newbe = false;
end

if Reportstruct(1).newbe

    Status.failed = true;
    Status.errormsg = '';
    Status.savedas = '';

else
    global Zset

    Status = [];

    % Uses value specified in Zset
    if nargin<2
        if isfield(Zset,'report_aopen') && Zset.report_aopen
            openfile=true;
        else
            openfile=false;
        end
    end

end

% Add check for formatting characters in strings and handle them as
% nonformatting. Check with outputs from qq_loadfile

linefeed=char([13 10]);

% ------------- Opens file -------------
Reportstruct(1).pathname=[Reportstruct.pathname];
fh=fopen([Reportstruct(1).pathname '.txt'],'w');

if fh==-1
    if Reportstruct(1).newbe
        Status.errormsg = 'Could not write to file, file may be open or output folder may not exist';
    else
        zz_message(1,'Warning, could not write to file, file may be open or output folder may not exist','-r');
    end
else
    for tn=1:length(Reportstruct)

        % ------------- Writes header -------------

        if isfield(Reportstruct,'header') && ~isempty(Reportstruct(tn).header)
            for x=1:length(Reportstruct(tn).header)
                fprintf(fh,[convstr(Reportstruct(tn).header{x}) ' ' linefeed]);
            end
        end

        % ------------- Writes table -------------

        n_columns = size(Reportstruct(tn).cells,1);

        % Column Headers
        n_headers = 0; ColumnHeaders = cell(0); HeaderFormats = cell(0);
        if isfield(Reportstruct,'columntitle') 
            [n_tcols,n_headers] = size(Reportstruct(tn).columntitle);
            ColumnHeaders = cell(max(n_columns,n_tcols),n_headers); 
            [ColumnHeaders(1:n_tcols,1:n_headers)] = Reportstruct(tn).columntitle(1:n_tcols,1:n_headers);
            ColumnHeaders(cellfun(@isempty,ColumnHeaders)) = {''};
            HeaderFormats(max(n_columns,n_tcols),n_headers) = {[]};
        end

        % column headers
        rowsep = cell(0); rowsep(1:n_columns,1) = {''};
        if n_headers>0
            CellContent = [ColumnHeaders rowsep Reportstruct(tn).cells]';
            Formats = [HeaderFormats rowsep Reportstruct(tn).format]';
        else
            CellContent = Reportstruct(tn).cells';
            Formats = Reportstruct(tn).format';
        end

        % create celloutput
        S = []; colsep = repmat(' ',size(CellContent,1),2);
        for cno = 1:n_columns
            S = [S char(zz_colalign(CellContent(:,cno),Formats(:,cno),'decimal')) colsep];
        end
        S(:,end-1:end) = [];

        sepline = repmat('-',1,size(S,2));
        if n_headers>0
            S(n_headers+1,:) = sepline;
        end
        S = [S; sepline];

        nrows = size(S,1);
        for x=1:nrows
            fprintf(fh,[convstr(S(x,:)) linefeed]);
        end

        % ------------- Writes footer -------------

        if isfield(Reportstruct,'footer') && ~isempty(Reportstruct(tn).footer)
            for x=1:length(Reportstruct(tn).footer)
                fprintf(fh,[convstr(Reportstruct(tn).footer{x}) ' ' linefeed]);
            end
        end
        
        % Add blank line to separate multiple outputs
        if numel(Reportstruct)>1 && tn<numel(Reportstruct)
            fprintf(fh,[' ' linefeed]);
        end        

    end % for tn

    if Reportstruct(1).newbe
        Status.savedas = [Reportstruct(1).pathname '.txt'];
        Status.failed = false;
    else
        zz_message(1,['Saved as: ' Reportstruct(1).pathname '.txt'],'-b')
        Zset.lastexport=[Reportstruct(1).pathname '.txt'];
    end
    fclose(fh);

    % Opens
    if ~Reportstruct(1).newbe

        if openfile && ispc
            try
                winopen([Reportstruct(1).pathname '.txt']);
            catch
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'GLNX',4)
            err=system(['xdg-open "' Reportstruct(1).pathname '.txt"']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        if openfile && strncmpi(computer,'MAC',3)
            err=system(['open ''' Reportstruct(1).pathname '.txt''']);
            if err
                zz_message(1,'Could not open file','-r');
            end
        end

        % Suppress output 
        if ~nargout
            clearvars
        end

    end
    
end % if fid==-1


% ====== Subfunction convstr =====
function str=convstr(str)
% Converts special characters in strings for fprintf
% \\ --> \\
% % --> %%
% ' --> ''

if isempty(str) str = ''; end % ensure empties are chars

if ~ischar(str) return; end

str=strrep(str,'\','\\');
str=strrep(str,'%','%%');
str=strrep(str,'''','''''');






