function zz_report_xls_single(Reportstruct,aopen)
% function zz_report_xls_single(Reportstruct,aopen)
% ver 200729 SAM
% global Zset
%

global Zset

%if isunix || exist('xlswrite')~=2
%    zz_message(1,'Excel export is not supported by current Matlab version. Try slk, csv or dif export','-r'); 
%    return; 
%end

% Uses value specified in Zset
if nargin<2
    if isfield(Zset,'report_aopen') && Zset.report_aopen 
        aopen=true;
    else
        aopen=false;
    end       
end

% deletes old file
if exist([Reportstruct(1).pathname '.xls'])==2
    delete([Reportstruct(1).pathname '.xls'])
end

lno=0;
for tn=1:length(Reportstruct)

    % ------------- Writes header -------------
    if isfield(Reportstruct,'header') && ~isempty(Reportstruct(tn).header)
        for x=1:length(Reportstruct(tn).header)
            lno=lno+1;
            Outstr{lno,1}=[' ' Reportstruct(tn).header{x}];
        end
    end
        
    % ------------- convert to typstr -------------
    [n_columns,n_rows]=size(Reportstruct(tn).cells);
    n_headerlines=0;
    if isfield(Reportstruct,'columntitle')
        [dummy,n_headerlines]=size(Reportstruct(tn).columntitle);
    end
    U=[]; typestr=[];

    for hn=1:n_headerlines
        lno=lno+1; 
        for cn=1:n_columns
            Outstr{lno,cn}=[' ' Reportstruct(tn).columntitle{cn,hn}];
        end
    end
    
    for rn=1:n_rows
        lno=lno+1;
        for cn=1:n_columns
            if strcmp(Reportstruct(tn).format{cn,rn},'str')
                Outstr{lno,cn}=[' ' Reportstruct(tn).cells{cn,rn}];
            else
                Outstr{lno,cn}=Reportstruct(tn).cells{cn,rn};
                if isnan(Reportstruct(tn).cells{cn,rn})
                    Outstr{lno,cn}='NaN'; 
                end                    
            end
        end
    end
    
    if isfield(Reportstruct,'footer') && ~isempty(Reportstruct(tn).footer)
        for x=1:length(Reportstruct(tn).footer)
            lno=lno+1;
            Outstr{lno,1}=Reportstruct(tn).footer{x};
        end    
    end
    
    % Add blank line to separate multiple outputs
    if numel(Reportstruct)>1 && tn<numel(Reportstruct)
        lno=lno+1;
        Outstr{lno,1}=' ';
    end
    
end % for tn

% Save the file
pathname = [Reportstruct(1).pathname '.xls'];
try 
    % Tries first with writecell
    % From Matlab2019a. Does not require Excel.
    writecell(Outstr,pathname); 
    Zset.lastexport=pathname;    
    zz_message(1,['Saved as: ' pathname],'-b')
    %disp('----- used writecell -----')
catch
    try
        % Tries xlswrite. Supported on old Matlab versions, but requires
        % that Excel is installed
        xlswrite(pathname,Outstr)
        Zset.lastexport=pathname; 
        zz_message(1,['Saved as: ' pathname],'-b')
        %disp('----- used xlswrite -----')
    catch
        zz_message(1,'XLS write failed.','-r')
        zz_message(7,'XLS write failed. File may be open, folder non-existent, or xls write may not be supported by current Matlab version (try slk, csv or dif export)')
        return
    end
end
        
% Open the file
if aopen && ispc
    try
        winopen(pathname);
    catch
        zz_message(1,'Could not open file','-r')
    end
end
if aopen && strncmpi(computer,'GLNX',4)
    err=system(['xdg-open "' pathname '"']);
    if err
        zz_message(1,'Could not open file','-r')
    end
end
if aopen && strncmpi(computer,'MAC',3)
    err=system(['open ''' pathname '''']);
    if err
        zz_message(1,'Could not open file','-r')
    end
end






